% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_benchmark.R
\name{plot_benchmark}
\alias{plot_benchmark}
\title{Plot benchmarking analysis scores}
\usage{
plot_benchmark(benchmarked, metric = "pcc")
}
\arguments{
\item{benchmarked}{List: output object from function \code{benchmarked}.}

\item{metric}{Character: the metric of evaluation. Options include Pearson
Correlation Coefficient ('pcc'), Concordance Correlation Coefficient ('ccc'), 
Coefficient of Determination ('adj.r2') and Root Mean Square Error ('rmse') 
of the linear regression model.}
}
\value{
Plot showing correlations across algorithms and cell types.
}
\description{
\code{plot_benchmark} plots the median correlation scores 
between estimated and measured cell types across methods and cell types.
}
\examples{
# load demo PBMCS data
load_ABIS()

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix_ABIS_S0)

# bechmark
bench<- benchmark(deconvoluted = decon, 
ground_truth = groundTruth_ABIS)

# plot bechmark
plot_benchmark(benchmarked = bench, 
metric = 'pcc')

}
\author{
Vincent Kuettel, Sabina Pfister
}
