% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_TPM.R
\name{get_TPM}
\alias{get_TPM}
\title{Convert raw counts to TPM}
\usage{
get_TPM(counts, effLen)
}
\arguments{
\item{counts}{Bulk RNAseq: a genes (rows) by samples (columns) matrix
containing gene raw counts.}

\item{effLen}{Vector of gene lengths.}
}
\value{
Returns a transcript-per-million (TPM)-normalized matrix.
}
\description{
\code{get_TPM} is used to convert raw counts to TPMs,
which is the most suitable normalization for deconvolution.
}
\examples{
# get TPMs from raw counts and gene lengths.
mat <- round(matrix(rexp(200, rate=.01), ncol=20))
len <- round(matrix(rexp(10, rate=.001), ncol=1))+10
tpm <- get_TPM(mat,as.vector(len))

}
\author{
Vincent Kuettel, Sabina Pfister
}
