% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconvolute.R
\name{deconvolute}
\alias{deconvolute}
\title{Deconvolution from bulk RNAseq}
\usage{
deconvolute(m, sigMatrix, methods = get_decon_methods(), use_cores = 1)
}
\arguments{
\item{m}{Bulk RNAseq: a genes (rows) by samples (columns) matrix
containing transcript-per-million (TPM)-normalized gene expression values.}

\item{sigMatrix}{Reference profile: a matrix or a named list of matrices.
Each signature matrix should be a genes (rows) by cell types (columns) data
frame containing TPM-normalized gene expression values of signature genes.}

\item{methods}{Deconvolution methods: a character vector containing the names
of the deconvolution methods to be applied. By default, all methods are run.
Functions are either reimplementations of published methods or wrapper
functions for published packages:
\itemize{
\item{ols: ordinary least squares}
\item{nnls: non negative least squares
regression model. Adapted from Abas et al. (2009)}
\item{qprog: quadratic programming without constraints}
\item{qprogwc: quadratic programming non-negative and sum-to-one constraints.
Adapted from Gong et al. (2015)}
\item{dtangle: wrapper for the cell deconvolution function \code{\link[dtangle]{dtangle}}
form the package \pkg{dtangle}}
\item{rls: robust linear regression. Adapted from Monaco
et al. (2019)}
\item{svr: support vector regression. Adapted from Newman et al.
(2015)}
}}

\item{use_cores}{Number of cores to use for parallel processing}
}
\value{
Returns a list containing two elements: \itemize{
\item{coefficients: estimated cell type coefficients}
\item{proportions: estimated cell type proportions in percentage}
\item{combinations: combination of methods and signatures tested}
}
}
\description{
\code{deconvolute} predicts cell type proportions from bulk
RNAseq data by applying multiple deconvolution methods.
}
\examples{
# load demo PBMCS data
load_ABIS()

# generate list of reference profiles to be tested
sigMatrix <- list(
sig1 = sigMatrix_ABIS_S0, 
sig2 = sigMatrix_ABIS_S1)

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix)

}
\author{
Vincent Kuettel, Sabina Pfister
}
