% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{correlate}
\alias{correlate}
\title{Pearson correlation of cell type proportions across cell types 
and methods}
\usage{
correlate(deconvoluted, scale = TRUE)
}
\arguments{
\item{deconvoluted}{A list: output object from \code{deconvolute}}

\item{scale}{Boolean: indicate whether the coefficients should be 
transformed to standard scores (default: scale = TRUE).}
}
\value{
Returns a list encompassing two data frames: \itemize{
\item{the pearson correlation of coefficients with all other coefficients}
\item{summay: summary statistics of all-to-all correlation of coefficients 
by cell type}
\item{rank: ranking of deconvolution alghoritms by highest all-to-all 
correlation of coefficients}
\item{rank: ranking of deconvolution alghoritms by highest average 
regression all-to-all correlation of coefficients}
\item{combinations: combination of methods and signatures tested}
}
}
\description{
\code{correlate} computes Pearson correlations between
estimated cell type proportions generated by different methods.
}
\details{
\code{correlation_analysis} is particularly useful to assess the 
performance of the different methods when no ground truth is available. 
If several methods agree on similar relative abundances of cell types across 
samples, the results are more likely to reflect true differences in cell 
type composition.
}
\examples{
# load data
load_ABIS()

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix_ABIS_S0)

# correlate
correl <- correlate(deconvoluted = decon)

}
\author{
Vincent Kuettel, Sabina Pfister
}
