% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{benchmark}
\alias{benchmark}
\title{Regress estimated cell type proportions against the ground truth}
\usage{
benchmark(deconvoluted, ground_truth)
}
\arguments{
\item{deconvoluted}{Output object of the function \code{deconvolute}.}

\item{ground_truth}{A matrix containing measured cell type 
proportions in percentages. Samples names are inlcuded in rownames.}
}
\value{
Returns a list containing thres elements: \itemize{
\item{data: a list of data frames with celltype matched estimated and 
predicted proportions}
\item{stats: a list of data frames with regression statistics comprising 
Pearson Correlation Coefficient ('pcc'), Concordance Correlation Coefficient
('ccc'), Coefficient of Determination ('adj.r2') and Root Mean Square Error 
('rmse')}
\item{summary: a data frame with summary statistics by cell type}
\item{rank: ranking of deconvolution alghoritms by highest all-to-all 
correlation of coefficients}
\item{summay: summary statistics of regression coefficients by method, 
signature and cell type}
\item{rank: ranking of methods and signatures by highest average regression 
coefficient}
\item{combinations: combination of methods and signatures tested}
}
}
\description{
\code{regress} computes regression between estimated cell 
type proportions and the measured cell type  proportions (ground truth).
}
\examples{
# load demo PBMCS data
load_ABIS()

# deconvolute
decon <- deconvolute(m = bulkRNAseq_ABIS, 
sigMatrix = sigMatrix_ABIS_S0)

# bechmark
bench <- benchmark(deconvoluted = decon, 
ground_truth = groundTruth_ABIS)

}
\author{
Vincent Kuettel, Sabina Pfister
}
