% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_significant_N_genes.R
\name{set_significant_N_genes}
\alias{set_significant_N_genes}
\title{Set significant and number of genes}
\usage{
set_significant_N_genes(
  genelist,
  significance_by = "pvalue_effectsize",
  pvalue_threshold = 0.05,
  effectsize_threshold = 1,
  keep_max_n_genes = FALSE,
  keep_max_n_genes_by = "pvalue"
)
}
\arguments{
\item{genelist}{list, loaded genelist with goatea::read_validate_genelist()}

\item{significance_by}{string, default: 'pvalue_effectsize', else 'pvalue' or 'effectsize' to set gene significance to TRUE/FALSE in 'signif' column}

\item{pvalue_threshold}{numeric, default: 0.05, to set gene significance based on pvalue}

\item{effectsize_threshold}{numeric, default: 1, to set gene significance based on effectsize}

\item{keep_max_n_genes}{boolean, default: TRUE, filter down by pvalue to max n genes allowed by goat (max(goat::goat_nulldistributions$N))}

\item{keep_max_n_genes_by}{string, default: 'pvalue', else 'effectsize', order genes based on lowest pvalues or highest absolute effect sizes}
}
\value{
genelist with added 'signif' column with TRUE/FALSE values
}
\description{
Set significant and number of genes
}
\examples{
set_significant_N_genes(
  get(load(system.file("extdata", "example_genelist.rda", package = "goatea")))
)
}
