% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_validate_genelist.R
\name{read_validate_genelist}
\alias{read_validate_genelist}
\title{Read and validate a table with genes (that should be tested in overrepresentation-analysis) for compatibility with this R package#'}
\usage{
read_validate_genelist(
  file,
  remove_non_numerical_ids = TRUE,
  remove_duplicated = TRUE,
  remove_Rik_genes = TRUE,
  remove_Gm_genes = TRUE,
  map_organism = NULL
)
}
\arguments{
\item{file}{full filepath to gene tibble in .csvs/.xlsx/.tsv}

\item{remove_non_numerical_ids}{boolean, default TRUE, if non-numerical in gene column, remove}

\item{remove_duplicated}{boolean, default TRUE, removes duplicated gene symbols/ids}

\item{remove_Rik_genes}{boolean, default TRUE, grepl("Rik$") search and remove Riken non-canonical mouse genes}

\item{remove_Gm_genes}{boolean, default TRUE, grepl("^Gm") search and remove Gm non-canonical mouse genes}

\item{map_organism}{default: NULL, if numeric taxid, used for selecting org.Xx.eg.db to map gene symbols to gene column via AnnotationDbi::mapIds(keytype = 'ALIAS') - if mapped to NA the genes are removed - need to download org.Xx.eg.db manually! Symbols are set toupper() to match formatting. Protein symbols could be used too.
\itemize{
\item 9606 = Human (Homo sapiens) (org.Hs.eg.db)
\item 9544 = Rhesus monkey (Macaca mulatta) (org.Mmu.eg.db)
\item 10090 = Mouse (Mus musculus) (org.Mm.eg.db)
\item 10116 = Rat (Rattus norvegicus) (org.Rn.eg.db)
\item 7227 = Fruit fly (Drosophila melanogaster) (org.Dm.eg.db)
\item 6239 = Worm (Caenorhabditis elegans) (org.Ce.eg.db)
}}
}
\value{
tibble dataframe with columns: symbol (string), gene (string as integer ID), pvalue (numeric), effestsize (numeric)
}
\description{
if 'pvalue' is not in the genelist columns, it is set and defaulted to 1 for visualization purposes
if 'effectsize' is not in the genelist columns, it is set and defaulted to 0 for visualization purposes
}
\examples{
file_path <- system.file("extdata", "example_genelist.csv", package = "goatea")
read_validate_genelist(file = file_path)
}
