% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_genelists_overlap.R
\name{plot_genelists_overlap_upsetjs}
\alias{plot_genelists_overlap_upsetjs}
\title{Visualize genelists gene overlap in an interactive UpSet plot}
\usage{
plot_genelists_overlap_upsetjs(
  genelists,
  mode = "distinct",
  interactive = FALSE,
  main.color = "black",
  highlight.color = "green"
)
}
\arguments{
\item{genelists}{UI value/list of tibbles/dataframes}

\item{mode}{string, default: 'intersect', else 'distinct' or 'union' - how to overlap the listed genes}

\item{interactive}{default: FALSE, else TRUE}

\item{main.color}{default: 'white' else character hexcolor or colorname}

\item{highlight.color}{default: 'green' else character hexcolor or colorname}
}
\value{
upset plot
}
\description{
UpSetJS examples: https://upset.js.org/integrations/r/articles/combinationModes.html#distinct-intersection-mode
}
\examples{
plot_genelists_overlap_upsetjs(list(
  A = get(load(system.file("extdata", "example_genelist.rda", package = "goatea"))), 
  B = get(load(system.file("extdata", "example_genelist.rda", package = "goatea")))
))
}
