% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gene_effectsize_ComplexHeatmap.R
\name{plot_gene_effectsize_ComplexHeatmap}
\alias{plot_gene_effectsize_ComplexHeatmap}
\title{Plot gene2effectsize ComplexHeatmap}
\usage{
plot_gene_effectsize_ComplexHeatmap(
  genes,
  genes_overview,
  rows_dendrogram = TRUE,
  cols_dendrogram = TRUE,
  plot_n_genes = 50
)
}
\arguments{
\item{genes}{character, genes to visualize}

\item{genes_overview}{dataframe, containing columns: 'symbol', 'SAMPLE_efsi' and 'SAMPLE_pval'}

\item{rows_dendrogram}{default: FALSE, TRUE to cluster rows and show dendrogram}

\item{cols_dendrogram}{default: FALSE, TRUE to cluster columns and show dendrogram}

\item{plot_n_genes}{integer, default: 50, NULL to plot all genes}
}
\value{
ComplexHeatmap object
}
\description{
Plot gene2effectsize ComplexHeatmap
}
\examples{
plot_gene_effectsize_ComplexHeatmap(
  c('gene_1', 'gene_2', 'gene_3', 'gene_4', 'gene_5'), 
  get(load(system.file("extdata", "example_genes_overview.rda", package = "goatea")))
)
}
