% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_EnhancedVolcano.R
\name{plot_EnhancedVolcano}
\alias{plot_EnhancedVolcano}
\title{Plot EnhancedVolcano}
\usage{
plot_EnhancedVolcano(
  genelist,
  effectsize_threshold = 1,
  pvalue_threshold = 0.05,
  background_color = "black",
  foreground_color = "white",
  interactive = FALSE,
  legend_labels = c("NS", "FC", "P", "FC & P"),
  x_label = "effectsize (FC)",
  y_label = "-log10(pvalue) (P)",
  title = "Volcano plot",
  subtitle = "EnhancedVolcano",
  caption = paste0("N genes: ", nrow(genelist)),
  label_size = 3,
  legend_label_size = 14,
  axes_label_size = 18,
  point_size = 2
)
}
\arguments{
\item{genelist}{UI value/list of tibbles/dataframes}

\item{effectsize_threshold}{numeric, default: 1, threshold for showing significance on effectsize axis}

\item{pvalue_threshold}{numeric, default: 0.05, threshold for showing significance on pvalue axis}

\item{background_color}{default: 'black', else character hexcolor or colorname}

\item{foreground_color}{default: 'white', else character hexcolor or colorname}

\item{interactive}{default: FALSE, else TRUE}

\item{legend_labels}{character vector, default: c('NS', 'FC', 'P', 'FC & P'), plot legend labels}

\item{x_label}{character, default: 'effectsize (FC)', plot x-axis label}

\item{y_label}{character, default: "'-log10(pvalue) (P)', plot y-axis label}

\item{title}{character, default: 'Volcano plot', plot title}

\item{subtitle}{character, default: 'EnhancedVolcano', plot subtitle}

\item{caption}{character, default: paste0("N genes: ", nrow(genelist)), plot caption}

\item{label_size}{numeric, default: 3, plot variable label size}

\item{legend_label_size}{numeric, default: 14, plot legend label size}

\item{axes_label_size}{numeric, default: 18, plot x- and y-axis lable sizes}

\item{point_size}{numeric, default: 2, plot point size}
}
\value{
plotly or ggplot2 object
}
\description{
Plot EnhancedVolcano
}
\examples{
plot_EnhancedVolcano(
  get(load(system.file("extdata", "example_genelist.rda", package = "goatea")))
)
}
