% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gene_geneset_ComplexHeatmap.R
\name{plot_ComplexHeatmap}
\alias{plot_ComplexHeatmap}
\title{Plot ComplexHeatmap}
\usage{
plot_ComplexHeatmap(
  enrichment_result,
  genelist,
  genes = NULL,
  cluster_method = "single",
  n_cluster = 1,
  n_top_terms = NA,
  n_top_genes = NA,
  genelist_overlap = NULL,
  plot = FALSE
)
}
\arguments{
\item{enrichment_result}{dataframe containing enrichment analysis results.
Must include \code{name} (gene set names) and \code{symbol} (listed genes associated with gene sets)}

\item{genelist}{dataframe with gene-level statistics, including at least
\code{symbol}, \code{pvalue}, \code{effectsize}, and \code{signif} columns}

\item{genes}{character, default: NULL, if genes given, these are prioritized for visualization}

\item{cluster_method}{default: 'single', else one of \link{hclust} methods}

\item{n_cluster}{default: 1, integer, number of hierarchical clusters to define}

\item{n_top_terms}{default: NULL, if integer, plot only top genesets (recommended for visual clarity: 70)}

\item{n_top_genes}{default: NULL, if integer, plot only top genes (recommended for visual clarity: 150)}

\item{genelist_overlap}{(Optional) dataframe with gene overlap information, including
\code{symbol} and \code{genelist_overlap}, see run_genelists_overlap()}

\item{plot}{default: FALSE, if TRUE, display drawn ComplexHeatmap}
}
\value{
A \strong{ComplexHeatmap} object displaying genesets (rows) and genes (columns),
potentially clustered based on their binary associations. The heatmap includes:
\itemize{
\item Row annotations: Gene set size, p-value, and average effect size.
\item Column annotations: Gene p-values, effect sizes, and optional overlap categories.
\item Customized row/column labels highlighting significant elements.
\item A color-mapped heatmap showing clustering results.
}
}
\description{
Plot ComplexHeatmap from enrichment analysis results and corresponding genelist
}
\examples{
plot_ComplexHeatmap(
  get(load(system.file("extdata", "example_enrichment.rda", package = "goatea")))[seq.int(1, 3), ], 
  get(load(system.file("extdata", "example_genelist.rda", package = "goatea"))), 
  n_cluster = 3, 
  n_top_genes = 10
)
}
