% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_visNetwork.R
\name{get_visNetwork}
\alias{get_visNetwork}
\title{Get visNetwork graph}
\usage{
get_visNetwork(ppigraph, genes_overview = NULL, sample_name = NULL)
}
\arguments{
\item{ppigraph}{igraph object, get from \code{get_ppigraph()}}

\item{genes_overview}{(optional) dataframe, default: NULL, else metadata dataframe for ppigraph proteins/genes aliases}

\item{sample_name}{(optional) character, default: NULL, else sample name found in genes_overview columns}
}
\value{
list of visNetwork nodes and edges and given ppigraph
}
\description{
Gets visNetwork graph with ppigraph, and optionally genes overview, metadata
}
\examples{
ppi_graph <- get_ppigraph(
  get(load(system.file("extdata", "example_ppi_data.rda", package = "goatea")))
)
get_visNetwork(ppi_graph)
}
