% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_string_ppi.R
\name{get_string_ppi}
\alias{get_string_ppi}
\title{Get STRING database Protein-Protein Interactions}
\usage{
get_string_ppi(
  aliases,
  score_threshold = 0L,
  organism = 9606L,
  network_type = "full",
  link_data = "combined_only",
  folder = tempdir(),
  version = "latest",
  versions = NULL
)
}
\arguments{
\item{aliases}{character, vector with protein/gene symbols/aliases}

\item{score_threshold}{integer, default: 0, to get all PPI, ranges between \code{[0-1000]}, 200 for low, 400 for medium and 700 for high/stringent scoring PPI}

\item{organism}{integer, default: 9606 (Homo Sapiens), see \code{?goat::load_genesets_go_bioconductor} taxid parameter for possible organism taxIDs}

\item{network_type}{character, default: 'full', else 'physical' for only STRING documented physical interactions}

\item{link_data}{character, default: 'combined_only', else 'full' or 'detailed', see STRING documentation}

\item{folder}{character, default: tempdir(), else given folder path for where to download STRING files, converted to .parquet for compression and query efficiency, if tempdir() the temporary directory with the downloaded files are removed after the R session}

\item{version}{character, default: 'latest', else a version to check availability, e.g. "12.0", if version not available the available versions are printed}

\item{versions}{NULL, else character vector with versions to choose from with version}
}
\value{
dataframe (tibble) with protein-protein interactions (symbols and STRING IDs) and STRING combined score
}
\description{
STRING documentation: https://string-db.org/cgi/help?sessionId=baEZCS5u1RdM

Protocol used for downloading STRING files is https
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
get_string_ppi(c("TP53", "EGFR", "BRCA1", "MTOR", "MYC", "SOX2"))
\dontshow{\}) # examplesIf}
}
