% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_enrichment.R
\name{filter_enrichment}
\alias{filter_enrichment}
\title{Filter enrichment}
\usage{
filter_enrichment(
  df,
  genes_input = "",
  genes_any_all = c("any", "all"),
  terms_query = "",
  terms_query_all_any = c("any", "all"),
  terms_antiquery = "",
  terms_antiquery_all_any = c("any", "all"),
  min_ngenes = 0,
  min_ngenes_input = 0,
  min_ngenes_signif = 0,
  min_abs_zscore = 0,
  min_pvalue_adjust = 0,
  max_ngenes = 1e+06,
  max_ngenes_input = 1e+06,
  max_ngenes_signif = 1e+06,
  max_abs_zscore = 1e+06,
  max_pvalue_adjust = 1
)
}
\arguments{
\item{df}{enrichment output dataframe}

\item{genes_input}{default: UI input/character vector of genes to select df terms for}

\item{genes_any_all}{default: 'any', else 'all', use to define to take only specific terms containing any or all associated genes}

\item{terms_query}{dfeault: UI input/character vector of keywords to match (grepl) term names}

\item{terms_query_all_any}{default: 'any', else 'all', defines if terms should match any or all of the query keywords given}

\item{terms_antiquery}{dfeault: UI input/character vector of keywords to NOT match (grepl) term names}

\item{terms_antiquery_all_any}{default: 'any', else 'all', defines if terms should NOT match any or all of the query keywords given}

\item{min_ngenes}{default: 0, set higher to filter terms with less n genes}

\item{min_ngenes_input}{default: 0, else set higher to filter terms with less n input genes}

\item{min_ngenes_signif}{default: 0, set higher to filter terms with less n significant genes}

\item{min_abs_zscore}{default: 0, set higher to filter terms with less absolute zscore}

\item{min_pvalue_adjust}{default: 0, set higher to filter terms with lower multiple testing corrected p-value}

\item{max_ngenes}{default: 0, set lower to filter terms with more n genes}

\item{max_ngenes_input}{default: 0, else set lower to filter terms with more n input genes}

\item{max_ngenes_signif}{default: 0, set lower to filter terms with more n significant genes}

\item{max_abs_zscore}{default: 0, set lower to filter terms with more absolute zscore}

\item{max_pvalue_adjust}{default: 1, set lower to filter terms with higher adjusted p-value for multiple correction}
}
\value{
filtered dataframe
}
\description{
Search and filter and sort or summarize (compiled) enrichment output.
}
\examples{
filter_enrichment(
get(load(system.file("extdata", "example_enrichment.rda", package = "goatea"))), 
min_ngenes = 15)
}
