% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorify.R
\name{colorify}
\alias{colorify}
\title{Create and/or modify color/gradient palettes}
\usage{
colorify(
  n = NULL,
  colors = character(0),
  colors_lock = NULL,
  colors_names = character(0),
  colors_breakpoints = numeric(0),
  gradient_n = n,
  gradient_space = c("rgb", "Lab"),
  gradient_interpolate = c("linear", "spline"),
  hf = 1,
  sf = 1,
  lf = 1,
  rf = 1,
  gf = 1,
  bf = 1,
  hv = 0,
  sv = 0,
  lv = 0,
  rv = 0L,
  gv = 0L,
  bv = 0L,
  alpha = 1,
  rev = FALSE,
  plot = FALSE,
  export = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{n}{default: NULL, else integer, amount of colors to create, if palette selected and more colors requested they will be generated}

\item{colors}{character (vector), combination of selecting palette(s) by name (options: see display_palettes()), and/or vector of R color names and/or color hexcodes}

\item{colors_lock}{default: rep(FALSE, length(colors), numerical or logical index of colors (not) to be modified, if logical length != colors it will be cut or filled with TRUE/FALSE, prefix with '!' for logical vectors and '-' for numerical vectors to get inverse, see examples. If gradient_n \%\% length(colors) == 0, i.e. if gradient_n divisive by amount of colors without rest, set repeat given locking pattern}

\item{colors_names}{default: character(0), else character vector of color names}

\item{colors_breakpoints}{default: numeric(0), else numeric vector of breakpoints to colorRamp in between}

\item{gradient_n}{default: n, else integer, amount of colors to output as gradient, after completing palette for n colors}

\item{gradient_space}{default: "rgb", else "Lab", see ?grDevices::colorRamp()}

\item{gradient_interpolate}{default: "linear", else "spline", see ? grDevices::colorRamp()}

\item{hf}{hue factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{sf}{saturation factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{lf}{lightness/brightness factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{rf}{red factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{gf}{green factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{bf}{blue factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{hv}{hue value, default: 0, add value to values, linear from base value of 0}

\item{sv}{saturation value, default: 0, add value to values, linear from base value of 0}

\item{lv}{lightness/brightness value, default: 0, add value to values, linear from base value of 0}

\item{rv}{red value, default: 0, add value to values, linear from base value of 0}

\item{gv}{green value, default: 0, add value to values, linear from base value of 0}

\item{bv}{blue value, default: 0, add value to values, linear from base value of 0}

\item{alpha}{numeric, sets color alpha values}

\item{rev}{default: FALSE, if TRUE, reverse order of colors}

\item{plot}{default: FALSE, if TRUE plot pie chart of color palette}

\item{export}{default: FALSE, if TRUE: export = getwd(), if export = "string/", save hexcodes, rgb, and hsl values to export/colorify.csv}

\item{verbose}{default: TRUE, else FALSE - to log status messages}

\item{...}{additional arguments to pass on}
}
\value{
vector of color hexcodes
}
\description{
Note for colorblind use: "Okabe-Ito"

Addition of values happens before multiplication with factors.

Palette names are stripped of whitespace and lowered for name matching.
All RColorBrewer and Viridis palettes are included.

All grDevices plotting functions are provided as palettes, simply use colors = "rainbow", "heat", "terrain", "topo" or "cm".
}
\details{
Either generate theoretically maximally different colors, select an available R grDevices palette and/or modify the colors of the given gradient/palette
}
\examples{
colorify(10, plot = TRUE)
}
