% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade.R
\name{upgrade}
\alias{upgrade}
\alias{upgrade.equivSDhtest}
\alias{upgrade.equivSDhtestList}
\alias{upgrade.AllEquivSDhtest}
\title{Update the result of a Sorensen-Dice equivalence test.}
\usage{
upgrade(x, ...)

\method{upgrade}{equivSDhtest}(x, ...)

\method{upgrade}{equivSDhtestList}(x, ...)

\method{upgrade}{AllEquivSDhtest}(x, ...)
}
\arguments{
\item{x}{an object of class "equivSDhtest", "equivSDhtestList" or "AllEquivSDhtest".}

\item{...}{any valid parameters for function "equivTestSorensen" for its interface "table",
to recompute the test(s) according to these parameters.}
}
\value{
An object of the same class than \code{x}.
}
\description{
Recompute the test (or tests) from an object of class "equivSDhtest", "equivSDhtestList" or
"AllEquivSDhtest" (i.e.,the output of functions "equivTestSorensen" or "allEquivTestSorensen").
Using the same table or tables of enrichment frequencies in 'x', obtain again the result of the
equivalence test for new values of any of the parameters \code{d0} or \code{conf.level} or
\code{boot} or \code{nboot} or \code{check.table}.
}
\section{Methods (by class)}{
\itemize{
\item \code{upgrade(equivSDhtest)}: S3 method for class "equivSDhtest"

\item \code{upgrade(equivSDhtestList)}: S3 method for class "equivSDhtestList"

\item \code{upgrade(AllEquivSDhtest)}: S3 method for class "allEquivSDhtest"

}}
\examples{
# Result of the equivalence test between gene lists 'sanger' and 'atlas', in dataset
# 'allOncoGeneLists', at level 4 of the BP ontology:
data(eqTest_atlas.sanger_BP4)
eqTest_atlas.sanger_BP4
class(eqTest_atlas.sanger_BP4)
# This may correspond to the result of code like:
# data(allOncoGeneLists)
# library(org.Hs.eg.db)
# humanEntrezIDs <- keys(org.Hs.eg.db, keytype = "ENTREZID")
# eqTest_atlas.sanger_BP4 <- equivTestSorensen(
#   allOncoGeneLists[["sanger"]], allOncoGeneLists[["atlas"]],
#   geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db",
#   onto = "BP", GOLevel = 4, listNames = c("sanger", "atlas"))
upgrade(eqTest_atlas.sanger_BP4, d0 = 1/(1 + 10/9)) # d0 = 0.4737
upgrade(eqTest_atlas.sanger_BP4, d0 = 1/(1 + 2*1.25)) # d0 = 0.2857
upgrade(eqTest_atlas.sanger_BP4, d0 = 1/(1 + 2*1.25), conf.level = 0.99)

# All pairwise equivalence tests at level 4 of the BP ontology
data(eqTest_all_BP4)
?eqTest_all_BP4
class(eqTest_all_BP4)
# This may correspond to a call like:
# data(allOncoGeneLists)
# library(org.Hs.eg.db)
# humanEntrezIDs <- keys(org.Hs.eg.db, keytype = "ENTREZID")
# eqTest_all_BP4 <- equivTestSorensen(allOncoGeneLists,
#                           geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db",
#                           onto = "BP", GOLevel = 4)
upgrade(eqTest_all_BP4, d0 = 1/(1 + 2*1.25)) # d0 = 0.2857

data(allEqTests)
?allEqTests
class(allEqTests)
upgrade(allEqTests, d0 = 1/(1 + 2*1.25)) # d0 = 0.2857

}
