% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allSorenThreshold.R
\name{allSorenThreshold}
\alias{allSorenThreshold}
\alias{allSorenThreshold.list}
\alias{allSorenThreshold.allTableList}
\title{Iterate \code{sorenThreshold} along the specified GO ontologies and GO levels}
\usage{
allSorenThreshold(x, ...)

\method{allSorenThreshold}{list}(
  x,
  geneUniverse,
  orgPackg,
  boot = FALSE,
  nboot = 10000,
  boot.seed = 6551,
  ontos = c("BP", "CC", "MF"),
  GOLevels = seq.int(3, 10),
  trace = TRUE,
  alpha = 0.05,
  precis = 0.001,
  ...
)

\method{allSorenThreshold}{allTableList}(
  x,
  boot = FALSE,
  nboot = 10000,
  boot.seed = 6551,
  ontos,
  GOLevels,
  trace = TRUE,
  alpha = 0.05,
  precis = 0.001,
  ...
)
}
\arguments{
\item{x}{either an object of class "list" or an object of class "allTableList". In the first
case, each of its elements must be a "character" vector of gene identifiers (e.g., ENTREZ). In the second case,
the object corresponds to all contingency tables of joint enrichment along one or more GO
ontologies and one or more GO levels.}

\item{...}{extra parameters for function \code{buildEnrichTable}.}

\item{geneUniverse}{character vector containing the universe of genes from where gene lists have been extracted. This vector must be obtained from the annotation package declared in orgPackg. For more details see \href{../doc/README.html}{README File}.}

\item{orgPackg}{A string with the name of the genomic annotation package corresponding to a specific species to be analyzed, which must be previously installed and activated. For more details see \href{../doc/README.html}{README File}.}

\item{boot}{boolean. If TRUE, the confidence intervals and the test p-values are computed by means
of a bootstrap approach instead of the asymptotic normal approach. Defaults to FALSE.}

\item{nboot}{numeric, number of initially planned bootstrap replicates. Ignored if
\code{boot == FALSE}. Defaults to 10000.}

\item{boot.seed}{starting random seed for all bootstrap iterations. Defaults to 6551.
see the details section}

\item{ontos}{"character", GO ontologies to analyse.}

\item{GOLevels}{"integer", GO levels to analyse inside each one of these GO ontologies.}

\item{trace}{Logical. If TRUE (default), the (usually very time consuming) process
is traced along the specified GO ontologies and levels.}

\item{alpha}{simultaneous nominal significance level for the equivalence tests to be repeteadly performed,
defaults to 0.05}

\item{precis}{numerical precision in the iterative search of the equivalence threshold dissimilarities,}
}
\value{
An object of class "distList". It is a list with as many components as GO ontologies have been
analysed. Each of these elements is itself a list with as many components as GO levels have been
analysed. Finally, the elements of these lists are objects of class "dist" with the Sorensen-Dice
equivalence threshold dissimilarity.
}
\description{
Iterate \code{sorenThreshold} along the specified GO ontologies and GO levels
}
\section{Methods (by class)}{
\itemize{
\item \code{allSorenThreshold(list)}: S3 method for class "list"

\item \code{allSorenThreshold(allTableList)}: S3 method for class "allTableList"

}}
\examples{
# # This example is highly time-consuming. It scans two GO ontologies and three
# # GO levels inside them to perform the equivalence test.

# Obtaining ENTREZ identifiers for the gene universe of humans:
# library(org.Hs.eg.db)
# humanEntrezIDs <- keys(org.Hs.eg.db, keytype = "ENTREZID")

# # Gene lists to be explored for enrichment:
# data("allOncoGeneLists")
# allSorenThreshold(allOncoGeneLists,
#                   geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db",
#
# Much faster:
# Object allContTabs of class "allTableList" contains all the pairwise contingency tables of
# joint enrichment for the gene lists in \code{allOncoGeneLists}, obtained along all three GO
# ontologies and along GO levels 3 to 10:
data(allContTabs)
dSors <- allSorenThreshold(allContTabs, ontos = c("MF", "BP"), GOLevels = seq.int(4,6))
dSors$BP$`level 5`

}
