% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allHclustThreshold.R
\name{allHclustThreshold}
\alias{allHclustThreshold}
\title{Iterate \code{hclustThreshold} along the specified GO ontologies and GO levels}
\usage{
allHclustThreshold(x, ontos, GOLevels, trace = TRUE, ...)
}
\arguments{
\item{x}{an object of class "distList".}

\item{ontos}{"character", GO ontologies to iterate. Defaults to the ontologies in 'x'.}

\item{GOLevels}{"integer", GO levels to iterate inside each one of these GO ontologies.}

\item{trace}{Logical. If TRUE (default), the process
is traced along the specified GO ontologies and levels.}

\item{...}{extra parameters for function \code{hclustThreshold}.}
}
\value{
An object of class "equivClustSorensenList" descending from "iterEquivClust" which itself descends
from class "list".
It is a list with as many components as GO ontologies have been
specified. Each of these elements is itself a list with as many components as GO levels have been
specified. Finally, the elements of these lists are objects of class "equivClustSorensen", descending
from "equivClust" which itself descends from "hclust".
}
\description{
Iterate \code{hclustThreshold} along the specified GO ontologies and GO levels
}
\examples{
# Object \code{allTabs} of class "allTableList" contains all the pairwise contingency tables of
# joint enrichment for the gene lists in \code{allOncoGeneLists}, obtained along all three GO
# ontologies and along GO levels 3 to 10:
data(allContTabs)
# Compute the Sorensen-Dice equivalence threshold dissimilarity (only for the MF and CC
# ontologies and from levels 4 to 6):
dists <- allSorenThreshold(allContTabs, ontos = c("MF", "CC"), GOLevels = seq.int(4,6))
hclusts <- allHclustThreshold(dists)
hclusts$MF$`level 6`
plot(hclusts$MF$`level 6`)

}
