% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{makeLegends}
\alias{makeLegends}
\title{Add a legend}
\usage{
makeLegends(label_legend = FALSE, label_data = NULL,
  label_legend_title = "Gene Labels", feature_legend = FALSE,
  feature_data = NULL, feature_legend_title = "Features",
  scatterplot_legend = FALSE, scatterplot_legend_labels = c("Gains",
  "Losses"), point_colour = "black", point_outline_colour = "black",
  point_type = 21, scatterplot_legend_title = "Copy Number Variants",
  linegraph_legend = FALSE,
  linegraph_legend_labels = "Per Base Coverage",
  linegraph_legend_colours = "black",
  linegraph_legend_title = "Line Graph", background_colour = "white")
}
\arguments{
\item{label_legend}{Whether to make a legend for labels (good for
colour-coded labels).}

\item{label_data}{The label data.}

\item{label_legend_title}{Title for the label legend.}

\item{feature_legend}{Whether to make a legend for features.}

\item{feature_data}{The feature data to use for the feature legend.}

\item{feature_legend_title}{Title for the features legend.}

\item{scatterplot_legend}{Whether to make a legend for the scatterplot
track.}

\item{scatterplot_legend_labels}{A vector of the name/description of each
point e.g. if a point represents methylation, use 'methylation'. If we have
red/blue points for copy number gain/loss use c('gain', 'loss').}

\item{point_type, point_colour, point_outline_colour}{The type and colour of
points, as supplied to the \code{\link{drawScatterplotTrack}} function.}

\item{scatterplot_legend_title}{Title for scatterplot track legend.}

\item{linegraph_legend}{Whether to plot a legend for a line graph track.}

\item{linegraph_legend_labels}{A vector of label(s) for what the line graph
means (e.g. \code{'Per Base Coverage'} for a line graph track showing
coverage).}

\item{linegraph_legend_colours}{The colour of to the line graph track.}

\item{linegraph_legend_title}{A title for the line graph legend.}

\item{background_colour}{The colour of the background (either 'white' or
'black').}
}
\value{
An object of the Legends class.
}
\description{
Makes a legend object using ComplexHeatmap package which can
then be plotted using the \code{\link{gmovizPlot}} function.
}
\examples{
## a gene label legend
## the data
labels <- data.frame(chr=c('chr1', 'chr1'), start=c(100, 300),
end=c(150, 350), label=c('a', 'b'), type=c('gene', 'lncRNA'),
colour=c('red', 'blue'))

## making the legend
makeLegends(label_legend=TRUE, label_data=labels)
}
\seealso{
If you want more customisation over your legends, please see
\url{https://jokergoo.github.io/circlize_book/book/legends.html} for a
detailed guide as to how to implement legends alongside the circlize plots.
To plot these legends, see \code{\link{gmovizPlot}}
}
