% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_functions.R
\name{proprius}
\alias{proprius}
\title{Decomposition}
\usage{
proprius(y, X, type, offset = NULL, group = NULL,
        mu = NULL, phi = NULL,
        alpha = NULL, perm = 1000, plot = TRUE)
}
\arguments{
\item{y}{\strong{response variable}\strong{:}
numeric vector of length \code{n}}

\item{X}{\strong{covariate set}\strong{:}
numeric matrix with \code{n} rows (samples) 
and \code{p} columns (covariates)}

\item{type}{character '\strong{covariates}' or '\strong{samples}'}

\item{offset}{numeric vector of length \code{n}}

\item{group}{confounding variable\strong{:}
factor of length \code{n}}

\item{mu}{mean parameters\strong{:}
numeric vector of length \code{1} or \code{n}}

\item{phi}{dispersion parameter\strong{:}
non-negative real number}

\item{alpha}{significance level\strong{:} real number between 0 and 1}

\item{perm}{number of iterations\strong{:}
positive integer}

\item{plot}{plot of results\strong{:} logical}
}
\value{
If \code{alpha=NULL}, then the function returns a numeric vector,
and else a list of numeric vectors.
}
\description{
Even though the function \code{\link{omnibus}} tests
a single hypothesis on a whole covariate set,
this function allows to calculate
the individual contributions of \code{n} samples or
\code{p} covariates to the test statistic.
}
\details{
The user can provide a common \code{mu} for all samples
or sample-specific \code{mu}, and a common \code{phi}.
Setting \code{phi} equal to zero
is equivalent to using the Poisson model.
If \code{mu} is missing, then \code{mu} is estimated from \code{y}.
If \code{phi} is missing, then \code{mu} and \code{phi}
are estimated from \code{y}.
The \code{offset} is only taken into account
for estimating \code{mu} or \code{phi}.

The user can provide the confounding variable \code{group}.
Note that each level of \code{group} must appear at least twice
in order to allow stratified permutations.
}
\examples{
# simulate high-dimensional data
n <- 30; p <- 100
y <- rnbinom(n,mu=10,size=1/0.25)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)

# decomposition
proprius(y,X,type="samples")
proprius(y,X,type="covariates")

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)

JJ Goeman, SA van de Geer, F de Kort, and HC van Houwelingen (2004).
"A global test for groups of genes:
testing association with a clinical outcome",
\emph{Bioinformatics}. 20:93-99.
\href{http://dx.doi.org/10.1093/bioinformatics/btg382}{html}
\href{http://bioinformatics.oxfordjournals.org/content/20/1/93.full.pdf}{pdf}
(open access)
}
\seealso{
The function \code{\link{omnibus}} tests for associations
between an overdispersed response variable and a high-dimensional
covariate set.
The function \code{\link{cursus}} tests for association
between RNA-Seq and local genetic or epigenetic alternations
across the whole genome.
All other functions of the R package \code{\link{globalSeq}}
are \code{\link{internal}}.
}
\keyword{methods}
