% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_options.R
\name{heuristicScale}
\alias{heuristicScale}
\title{Heuristic function to use in high dimensions}
\usage{
heuristicScale(
  x,
  subExp10 = -1,
  expMult = -1,
  subExp = -1,
  sub.exp10 = deprecated(),
  exp.mult = deprecated(),
  sub.exp = deprecated()
)
}
\arguments{
\item{x}{vector of values to scale}

\item{subExp10}{value to subtract to base 10 exponential, for example:
\code{10^0 - subExp10 = 1 - subExp10}}

\item{expMult}{parameter to multiply exponential, i.e. to have a negative
exponential or positive}

\item{subExp}{value to subtract for exponentional, for example if x = 0,
\code{exp(0) - sub.exp = 1 - sub.exp}}

\item{sub.exp10}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{exp.mult}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{sub.exp}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
a vector of scaled values
}
\description{
Heuristic function to use in high dimensions
}
\examples{
heuristicScale(rnorm(1:10))
}
