% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degree_cor.R
\name{degreeCor}
\alias{degreeCor}
\title{Calculate the degree of the correlation network based on xdata}
\usage{
degreeCor(
  xdata,
  cutoff = 0,
  considerUnweighted = FALSE,
  forceRecalcDegree = FALSE,
  forceRecalcNetwork = FALSE,
  nCores = 1,
  ...,
  consider.unweighted = deprecated(),
  force.recalc.degree = deprecated(),
  force.recalc.network = deprecated(),
  n.cores = deprecated()
)
}
\arguments{
\item{xdata}{calculate correlation matrix on each column.}

\item{cutoff}{positive value that determines a cutoff value.}

\item{considerUnweighted}{consider all edges as 1 if they are greater than
0.}

\item{forceRecalcDegree}{force recalculation of penalty weights (but not
the network), instead of going to cache.}

\item{forceRecalcNetwork}{force recalculation of network and penalty
weights, instead of going to cache.}

\item{nCores}{number of cores to be used.}

\item{...}{extra parameters for cor function.}

\item{consider.unweighted}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{force.recalc.degree}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{force.recalc.network}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{n.cores}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
a vector of the degrees.
}
\description{
Calculate the degree of the correlation network based on xdata
}
\examples{
n.col <- 6
xdata <- matrix(rnorm(n.col * 4), ncol = n.col)
degreeCor(xdata)
degreeCor(xdata, cutoff = .5)
degreeCor(xdata, cutoff = .5, considerUnweighted = TRUE)
}
