% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_lambda.R
\name{buildLambda}
\alias{buildLambda}
\title{Auxiliary function to generate suitable lambda parameters}
\usage{
buildLambda(
  lambdaLargest = NULL,
  xdata = NULL,
  ydata = NULL,
  family = NULL,
  ordersOfMagnitudeSmaller = 3,
  lambdaPerOrderMagnitude = 150,
  lambda.largest = deprecated(),
  orders.of.magnitude.smaller = deprecated(),
  lambda.per.order.magnitude = deprecated()
)
}
\arguments{
\item{lambdaLargest}{numeric value for largest number of lambda to consider
(usually with a target of 1 selected variable)}

\item{xdata}{X parameter for glmnet function}

\item{ydata}{Y parameter for glmnet function}

\item{family}{family parameter to glmnet function}

\item{ordersOfMagnitudeSmaller}{minimum value for lambda
(lambda.largest / 10^orders.of.magnitude.smaller)}

\item{lambdaPerOrderMagnitude}{how many lambdas to create for each order
of magnitude}

\item{lambda.largest}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{orders.of.magnitude.smaller}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{lambda.per.order.magnitude}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
a numeric vector with suitable lambdas
}
\description{
Auxiliary function to generate suitable lambda parameters
}
\examples{
buildLambda(5.4)
}
