% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylospm.R
\name{phylospm}
\alias{phylospm}
\title{Plot phylogenetic scatterplot matrix.}
\usage{
phylospm(
tr,
traits = NULL,
title = NULL,
xAxisLabels = NULL,
yAxisLabels = NULL,
tr.params = list(size = 1, colors = NULL, panel.grid = TRUE),
sptr.params = list(tippoint = TRUE, tiplab = FALSE, labdir = "horizonal",
                    panel.grid = TRUE)
)
}
\arguments{
\item{tr}{A phylogenetic tree}

\item{traits}{A data frame containing multiple column of trait data}

\item{title}{Set the title for the phylogenetic scatterplot matrix}

\item{xAxisLabels}{Set the label of the x axis}

\item{yAxisLabels}{Set the label of the y axis}

\item{tr.params}{List of parameters to customize the phylogenetic tree
with continuous trait mapping as continuous colors on the branch.

Users can add tip point, add tip label, set tip label direction and set
background gird.}

\item{sptr.params}{List of parameters to customize the phylomorphospaces.
Users can add tip point, add tip label, set tip label direction and set
background gird.}
}
\value{
phylospm object
}
\description{
This function creates a scatterplot matrix for comparing
multiple continuous traits mapped onto the same phylogenetic tree,
providing a visual representation of trait correlations and
evolutionary patterns.
}
\examples{
library(ggtree)
library(phytools)
library(ggtreeSpace)

tr <- rtree(10)
a <- fastBM(tr, nsim = 4)

phylospm(tr, a)
}
