% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_treespace.R
\name{geom_treespace}
\alias{geom_treespace}
\title{A layer of phylomorphospace}
\usage{
geom_treespace(tr, data, mapping = NULL, ...)
}
\arguments{
\item{tr}{a tree object. This should be an object of class that is
compatible with `ggtree`, typically an object of class
`phylo` or `treedata`.}

\item{data}{Trait data as a data frame or matrix, where each row
represents a tree tip or node.

    For data matching the number of tips, ancestral traits are reconstructed
    for internal nodes.

    For data equal to the total number of nodes, values are directly used as
    node coordinates.}

\item{mapping}{aesthetic mapping}

\item{...}{additional parameters for customization with `geom_tree`. Please
use `?ggtree::geom_tree` for more information.}
}
\value{
ggplot object
}
\description{
A layer of phylomorphospace
}
\examples{
library(ggplot2)
library(ggtree)
library(phytools)

tr <- rtree(10)
a <- fastBM(tr, nsim = 2)

p <- ggplot() +
    geom_treespace(tr, a)
}
