% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_points_jitterx.R
\name{position_points_jitterx}
\alias{position_points_jitterx}
\title{Randomly jitter the points in a ridgeline plot which can be shifted horizontally}
\usage{
position_points_jitterx(
  width = 0,
  height = 0.2,
  yoffset = 0,
  hexpand = NA,
  adjust_vlines = FALSE,
  seed = NULL
)
}
\arguments{
\item{width}{Width for horizontal jittering. By default set to 0.}

\item{height}{Height for vertical jittering, applied in both directions (up and down). By default 0.2.}

\item{yoffset}{Vertical offset applied in addition to jittering.}

\item{hexpand}{numeric, distance to be shifted horizontally for geoms that
have a position, default is NA.}

\item{adjust_vlines}{If \code{TRUE}, adjusts vertical lines (as are drawn for
quantile lines, for example) to align with the point cloud.}

\item{seed}{Random seed. If set to NULL, the current random number generator is used.
If set to NA, a new random random seed is generated. If set to a number, this
number is used as seed for jittering only.}
}
\description{
This is a position adjustment specifically for 'geom_density_ridges()' and related geoms. It
only jitters the points drawn by these geoms, if any. If no points are present, the plot
remains unchanged. The effect is similar to \code{\link[=position_jitter]{position_jitter()}}: points are randomly shifted up and down
and/or left and right. It add 'hexpand' that can control shift horizontally.
}
\seealso{
Other position adjustments for ridgeline plots: \code{\link{position_points_sinax}}, \code{\link{position_raincloudx}}
}
