% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestor_seq.R
\name{treeMSA_plot}
\alias{treeMSA_plot}
\title{treeMSA_plot}
\usage{
treeMSA_plot(
  p_tree,
  tidymsa_df,
  ancestral_node = "none",
  sub = FALSE,
  panel = "MSA",
  font = NULL,
  color = "Chemistry_AA",
  seq_colname = NULL,
  ...
)
}
\arguments{
\item{p_tree}{tree view}

\item{tidymsa_df}{tidy MSA data}

\item{ancestral_node}{vector, internal node in tree. Assigning a internal 
node to display "ancestral sequences",If ancestral_node = "none" hides 
all ancestral sequences, if ancestral_node = "all" shows all ancestral 
sequences.}

\item{sub}{logical value. Displaying a subset of ancestral sequences or not.}

\item{panel}{panel name for plot of MSA data}

\item{font}{font families, possible values are 'helvetical', 'mono', and 
'DroidSansMono', 'TimesNewRoman'.  Defaults is 'helvetical'. 
If font = NULL, only plot the background tile.}

\item{color}{a Color scheme. One of 'Clustal', 'Chemistry_AA', 
'Shapely_AA', 'Zappo_AA', 'Taylor_AA', 'LETTER', 'CN6', 'Chemistry_NT', 
'Shapely_NT', 'Zappo_NT', 'Taylor_NT'. Defaults is 'Chemistry_AA'.}

\item{seq_colname}{the colname of MSA on tree$data}

\item{...}{additional parameters for 'geom_msa'}
}
\value{
ggplot object
}
\description{
plot Tree-MSA plot
}
\details{
'treeMSA_plot()' automatically re-arranges the MSA data according to 
the tree structure,
}
\author{
Lang Zhou
}
