% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc.R
\name{gghelix}
\alias{gghelix}
\title{gghelix}
\usage{
gghelix(helix_data, color_by = "length", overlap = FALSE)
}
\arguments{
\item{helix_data}{a data frame. The file of nucleltide secondary structure
and then read by readSSfile().}

\item{color_by}{generate colors for helices by various rules,
including integer counts and value ranges one of "length" and "value"}

\item{overlap}{Logicals. If TRUE, two structures data called predict 
and known must be given(eg:heilx_data = list(known = data1, 
                                             predicted = data2)), 
plots the predicted helices that are known on top, predicted helices that
 are not known on the bottom, and finally plots unpredicted helices 
 on top in black.}
}
\value{
ggplot object
}
\description{
Plots nucleltide secondary structure as helices in arc diagram
}
\examples{
RF03120 <- system.file("extdata/Rfam/RF03120_SS.txt", package="ggmsa")
helix_data <- readSSfile(RF03120, type = "Vienna")
gghelix(helix_data)
}
\author{
Lang Zhou
}
