% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.R
\name{qqunif}
\alias{qqunif}
\title{Plot Quantile-Quantile Plot of p-values against uniform distribution.}
\usage{
qqunif(
  x,
  outfn = NULL,
  conf.int = 0.95,
  plot.width = 5,
  plot.height = 5,
  thin = TRUE,
  thin.n = 500,
  zero.pval = "replace"
)
}
\arguments{
\item{x}{a numeric vector of p-values. All values should be between 0 and 1.}

\item{outfn}{a character. File name to save the QQ Plot. If \code{outfn}
is supplied (i.e. \code{!is.null(outfn)}), then the plot is not drawn in
the graphics window.}

\item{conf.int}{a numeric between 0 and 1. Confidence band to draw around reference line. Set to \code{NA} to leave it out.}

\item{plot.width}{a numeric. Plot width in inches.}

\item{plot.height}{a numeric. Plot height in inches.}

\item{thin}{a logical. Reduce number of data points when they are cluttered?}

\item{thin.n}{an integer. Number of max points per horizontal partitions of the plot.
Defaults to 500.}

\item{zero.pval}{a character. Determine how to treat 0 pvals.
"replace" will replace the p-value of zero with the non-zero minimum.
"remove" will remove the p-value of zero.}
}
\value{
a ggplot object
}
\description{
Plot Quantile-Quantile Plot of p-values against uniform distribution.
}
\examples{
x <- rbeta(1000, 1, 1)
qqunif(x)
}
