% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gds_annotation.R
\name{gds_annotate}
\alias{gds_annotate}
\title{Annotation with GDS File}
\usage{
gds_annotate(
  x,
  gdsfile = NULL,
  annot.method = "position",
  chr = NULL,
  pos = NULL,
  ref = NULL,
  alt = NULL,
  rs.id = NULL,
  concat_char = "/",
  verbose = TRUE,
  annotation_names = c("annotation/info/symbol", "annotation/info/consequence",
    "annotation/info/LoF")
)
}
\arguments{
\item{x}{a \code{data.frame} object to be annotated.}

\item{gdsfile}{a character for GDS filename. If \code{NULL}, the default GDS file included with the package is used.}

\item{annot.method}{a method for searching variants. "position" requires \code{chr}, \code{pos}, \code{ref}, and \code{alt}. "rs.id" requires \code{rs.id}.}

\item{chr, pos, ref, alt, rs.id}{column names of \code{x} that contain chromosome, position, reference allele, alternate allele, and rs.id, respectively.}

\item{concat_char}{a character used to separate multiple annotations returned from the gds file.}

\item{verbose}{output messages.}

\item{annotation_names}{a character vector of nodes of the \code{gdsfile} that are to be extracted.}
}
\value{
A character vector the length of \code{nrow(x)} if \code{concat_char} is a character.
A data frame with \code{nrow(x)} rows and \code{length(annotation_names)} if \code{concat_char} is null.
}
\description{
Retrieve variant annotation stored in a GDS file with chromosome location or rs.id.
}
\examples{
vardata <- data.frame(
  chr = c(11,20,14),
  pos = c(12261002, 10033792, 23875025),
  ref = c("G", "G", "CG"),
  alt = c("A", "A", "C")
)

annotations <- gds_annotate(
  x = vardata, annot.method = "position",
  chr = "chr", pos = "pos", ref = "ref", alt = "alt"
)

print(annotations)

}
