% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{edge_matrix}
\alias{edge_matrix}
\title{edge_matrix}
\usage{
edge_matrix(
  graph,
  mat,
  gene_type = "SYMBOL",
  org = "hsa",
  org_db = NULL,
  num_combine = mean,
  name = "name",
  sep = " ",
  remove_dot = TRUE
)
}
\arguments{
\item{graph}{tbl_graph to append values to}

\item{mat}{matrix representing gene as row and sample as column}

\item{gene_type}{gene ID of matrix row}

\item{org}{organism ID to convert ID}

\item{org_db}{organism database to convert ID}

\item{num_combine}{function to combine multiple numeric values}

\item{name}{name column in node data, default to node}

\item{sep}{separater of name, default to " "}

\item{remove_dot}{remove "..." in node name}
}
\value{
tbl_graph
}
\description{
given the matrix representing gene as row and sample as column,
append the edge value (sum of values of connecting nodes) to edge matrix and
return tbl_graph object. The implementation is based on the paper by
Adnan et al. 2020 (https://doi.org/10.1186/s12859-020-03692-2).
}
\examples{
graph <- create_test_pathway()
num_df <- data.frame(row.names=c("6737","51428"),
                    "sample1"=c(1.1,1.2),
                    "sample2"=c(1.1,1.2),
                    check.names=FALSE)
graph <- graph \%>\% edge_matrix(num_df, gene_type="ENTREZID")
}
