% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combine_with_bnlearn}
\alias{combine_with_bnlearn}
\title{combine_with_bnlearn}
\usage{
combine_with_bnlearn(pg, str, av, prefix = "ko:", how = "any")
}
\arguments{
\item{pg}{reference graph (output of `pathway`)}

\item{str}{strength data.frame}

\item{av}{averaged network to plot}

\item{prefix}{add prefix to node name of original averaged network
like, `hsa:` or `ko:`.}

\item{how}{`any` or `all`}
}
\value{
tbl_graph
}
\description{
combine the reference KEGG pathway graph 
with bnlearn boot.strength output
}
\examples{
if (requireNamespace("bnlearn", quietly=TRUE)) {
    ## Simulating boot.strength() results
    av <- bnlearn::model2network("[6737|51428][51428]")
    str <- data.frame(from="51428",to="6737",strength=0.8,direction=0.7)
    graph <- create_test_pathway()
    combined <- combine_with_bnlearn(graph, str, av, prefix="hsa:")
}

}
