% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_flowJo_fasinh.R
\name{scales_flowjo_fasinh}
\alias{scales_flowjo_fasinh}
\alias{scale_x_flowjo_fasinh}
\alias{scale_y_flowjo_fasinh}
\alias{scale_x_flowJo_fasinh}
\alias{scale_y_flowJo_fasinh}
\title{Add a flowJo inverse hyperbolic sine scale to the x or y axes of a ggcyto plot.}
\usage{
scale_x_flowjo_fasinh(..., m = 4, t = 1200)

scale_y_flowjo_fasinh(..., m = 4, t = 1200)
}
\arguments{
\item{...}{common continuous scale parameters passed to 'continuous_scale' (not used currently)}

\item{m, t}{see 'help(flowjo_fasinh')}
}
\value{
ScaleContinuous object
}
\description{
Add a flowJo inverse hyperbolic sine scale to the x or y axes of a ggcyto plot.
}
\examples{
data(GvHD)
fr <- GvHD[[1]]
p <- ggcyto(fr, aes(x = `FL1-H`)) + geom_density()
#display at raw scale
p 
#display at transformed scale
p + scale_x_flowjo_fasinh(t = 1e4)
}
