% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_GEVAResults.R
\name{top.genes}
\alias{top.genes}
\title{Top Results from GEVA}
\usage{
top.genes(
  gevaresults,
  classif = c("similar", "factor-dependent", "factor-specific"),
  which.spec = levels(gevaresults),
  add.cols = NULL,
  ...,
  names.only = FALSE
)
}
\arguments{
\item{gevaresults}{a \code{\linkS4class{GEVAResults}} object}

\item{classif}{\code{character} vector, filters the returned genes by their final classification. Possible options are \code{"similar"}, \code{"factor-dependent"}, \code{"factor-specific"}, \code{"sparse"}, and \code{"basal"}. Multiple options can be combined}

\item{which.spec}{\code{factor}, filters the specific factors to be returned}

\item{add.cols}{\code{character} vector with column names from the feature table (accessed by \code{featureTable(gevaresults)}). The matching columns will be added to the returned table}

\item{...}{optional arguments (not used in this version)}

\item{names.only}{\code{logical}, set to \code{TRUE} to return only the table row names}
}
\value{
If \code{names.only} is \code{FALSE} (the default), returns a subset of the \code{resultstable} slot (\code{data.frame}) from the \code{gevaresults} that includes only the filtered genes according to the function parameters.

Otherwise, if \code{names.only} is \code{TRUE}, returns only the row names (\code{character} vector) of this table subset.
}
\description{
Extracts the genes with a relevant classification according to the GEVA results.
}
\examples{
## Basic usage with a random generated input
ginput <- geva.ideal.example() # Generates a random input example
gresults <- geva.quick(ginput) # Performs the entire analysis (default parameters)

# Gets a table that includes all the top genes
dtgenes <- top.genes(gresults) # Gets the top genes table
head(dtgenes)                  # Prints the first results

# Appends the "Symbol" column to the results table
dtgenes <- top.genes(gresults, add.cols="Symbol")
head(dtgenes)                  # Prints the first results

# Appends all feature columns to the results table
dtgenes <- top.genes(gresults, add.cols=names(featureTable(gresults)))
head(dtgenes)                  # Prints the first results

# Gets only the factor-specific genes
dtgenes <- top.genes(gresults, "factor-specific")
head(dtgenes)                  # Prints the first results

# Gets only the factor-specific genes for "Cond_1" factor (if any)
dtgenes <- top.genes(gresults, "factor-specific", "Cond_1")
head(dtgenes)                  # Prints the first results


}
