% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarization.R
\docType{data}
\name{geva.summarize}
\alias{geva.summarize}
\alias{options.summary}
\alias{options.variation}
\title{Summarizes the GEVAInput}

\usage{
geva.summarize(
  ginput,
  summary.method = options.summary,
  variation.method = options.variation,
  ...
)

options.summary
# c("mean", "median")

options.variation
# c("sd", "var", "mad")
}
\arguments{
\item{ginput}{a \code{\linkS4class{GEVAInput}} object}

\item{summary.method}{single \code{character}, method used to calculate the central (summarized) \emph{logFC} values}

\item{variation.method}{single \code{character}, method used to calculate the distribution degree (variation) of the \emph{logFC} values}

\item{...}{additional arguments. Accepts \code{verbose} (\code{logical}, default is \code{TRUE}) to enable or disable printing the current progress}
}
\value{
A \code{\linkS4class{GEVASummary}} object
}
\description{
Performs the summarization step by calculating the central points and variation estimates of \emph{logFC} values from the input data.
}
\details{
The \code{options.summary} refer to the available operations to calculate central \emph{logFC} values (\code{mean} or \code{median}), whereas \code{options.variation} presents three functions to calculate \emph{logFC} variation (\code{sd}: Standard Deviation; \code{var}: Variance; and \code{mad}: Median Absolute Deviation).
Moreover, all those operations include a weighted counterpart applied using the \code{weights} table from the \code{\linkS4class{GEVAInput}} object.
}
\examples{
## Summarization of a randomly generated input
ginput <- geva.ideal.example()     # Generates a random input example
gsummary <- geva.summarize(ginput) # Summarizes with the default parameters
plot(gsummary)                     # Plots the summarized data

}
\seealso{
\code{\link[base:mean]{base::mean()}}, \code{\link[stats:median]{stats::median()}}

\code{\link[stats:cor]{stats::var()}}, \code{\link[stats:sd]{stats::sd()}}, \code{\link[stats:mad]{stats::mad()}}
}
\keyword{datasets}
