% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{generics}
\alias{generics}
\alias{inputvalues}
\alias{inputweights}
\alias{inputdata}
\alias{inputnames}
\alias{infolist}
\alias{infolist<-}
\alias{factors}
\alias{factors<-}
\alias{classification.table}
\alias{classification.table<-}
\alias{analysis.params}
\alias{featureTable}
\alias{featureTable<-}
\alias{sv}
\alias{svattr}
\alias{elem.class}
\alias{elem.class<-}
\alias{groupsets}
\alias{groupsets<-}
\alias{groups}
\alias{scores}
\alias{centroids}
\alias{offsets}
\alias{sv.scores}
\alias{qindexes}
\alias{qareasizes}
\alias{qcount}
\alias{quantiles}
\alias{quantiles.method}
\alias{group.rels}
\alias{cluster.method}
\alias{results.table}
\alias{sv.data}
\alias{variation}
\alias{get.summary.method}
\alias{get.variation.method}
\alias{get.distance.method}
\alias{as.SVTable}
\title{GEVA Generic Methods}
\usage{
inputvalues(object)

inputweights(object, normalized)

inputdata(object)

inputnames(object)

infolist(object, field, ...)

infolist(object) <- value

factors(object)

factors(object) <- value

classification.table(object)

classification.table(object) <- value

analysis.params(gobject)

featureTable(object)

featureTable(object) <- value

sv(object)

svattr(S, V)

elem.class(typedlist)

elem.class(typedlist) <- value

groupsets(object)

groupsets(object) <- value

groups(object)

scores(object, group)

centroids(object)

offsets(object)

sv.scores(object)

qindexes(object)

qareasizes(object)

qcount(object)

quantiles(object)

quantiles.method(object)

group.rels(object)

cluster.method(object)

results.table(gres)

sv.data(object)

variation(object, ...)

get.summary.method(x)

get.variation.method(x)

get.distance.method(x)

as.SVTable(x, ...)
}
\arguments{
\item{object, x, gobject}{Primary object. See the documentation from each class for specific usages}

\item{normalized}{\code{logical}, whether to return values in the normalized scale}

\item{field}{When used with a information list, returns the information entry with the corresponding name}

\item{...}{Additional parameters. If used with an imported S3 method, passes the arguments to the default \code{vector}, \code{matrix} or \code{data.frame} implementation}

\item{value}{The value to be assigned}

\item{S}{Vector to construct the \code{S} slot}

\item{V}{Vector to construct the \code{V} slot}

\item{typedlist}{A \code{\linkS4class{TypedList}} object}

\item{group}{Character to filter the returned groups. Omit it to return all groups}

\item{gres}{A \code{\linkS4class{GEVAResults}} objec}
}
\value{
See the specific usages for each method.
}
\description{
Exhaustive list of generic methods exported from GEVA. Use \code{findMethods} to retrieve the specific usages.
}
\examples{
# Returing analysis parameters from an object
gsummary <- geva.summarize(geva.ideal.example(),
                           summary.method="mean",
                           variation.method="sd")
anpars <- analysis.params(gsummary)
print(anpars)
# $summary.method
# [1] "mean"
# $variation.method
# [1] "sd"

}
