% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_TypedList.R
\docType{class}
\name{TypedList-class}
\alias{TypedList-class}
\alias{typed.list}
\alias{elem.class,TypedList-method}
\alias{elem.class<-,TypedList,character-method}
\alias{show,TypedList-method}
\alias{[,TypedList,ANY,missing,missing-method}
\alias{[<-,TypedList,character,missing-method}
\alias{as.list.TypedList}
\alias{as.typed.list.vector}
\alias{as.typed.list.list}
\alias{as.typed.list.TypedList}
\title{Type-strict List (TypedList-class)}

\value{
A \code{\linkS4class{TypedList}} object
}
\description{
List containing elements of the same class or inheritance.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\code{list} of internal contents. Elements must match or inherit a common class
\cr (Inherited from \code{list})}

\item{\code{elem.class}}{\code{character} representing the class related to the elements}
}}

\examples{
## Creates a TypeList that stores list-derived objects
tpls = typed.list(A=list(1L:5L),
                  B=data.frame(v1=LETTERS[1L:10L]),
                  elem.class = 'list')

# Note: The 'elem.class' above is optional, since the
# class is automatically detected from the first argument

}
\section{Methods}{

\sspace\cr\strong{Constructors}
\describe{
\item{\code{typed.list(..., elem.class = NA_character_)}}{Creates a TypedList from the elements in \code{...} derived from the class \code{elem.class}}
}
\sspace\cr\strong{Conversion and coercion}
\describe{
\item{\code{as.list(x, ...)}}{Converts this object to \code{list}}
\item{\code{as.typed.list.list(x, elem.class = NA_character_)}}{Converts a \code{list} to a \code{TypedList} if its elements inherit the same type}
\item{\code{as.typed.list(x, elem.class = NA_character_)}}{Coerces a \code{TypedList} to support the inherited class indicated by \code{elem.class}}
\item{\code{as.typed.list.vector(x, elem.class = NA_character_)}}{Converts a vector to a \code{TypedList}}
}
\sspace\cr\strong{Properties}
\describe{
\item{\code{x[i, j, ...] <- value}}{Sets a value to this list. The \code{value} argument must be compatible to the current list type}
}
}

