% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_GEVAQuantiles.R
\docType{class}
\name{GEVAQuantiles-class}
\alias{GEVAQuantiles-class}
\alias{show,GEVAQuantiles-method}
\alias{plot,GEVAQuantiles,SVTable-method}
\alias{[,GEVAQuantiles,ANY,ANY,ANY-method}
\alias{qindexes,GEVAQuantiles-method}
\alias{qareasizes,GEVAQuantiles-method}
\alias{qcount,GEVAQuantiles-method}
\alias{sv.scores,GEVAQuantiles-method}
\alias{quantiles.method,GEVAQuantiles-method}
\alias{cluster.method,GEVAQuantiles-method}
\alias{quantiles,GEVAQuantiles-method}
\alias{classification.table,GEVAQuantiles-method}
\alias{classification.table<-,GEVAQuantiles,data.frame-method}
\alias{dim,GEVAQuantiles-method}
\alias{lines.GEVAQuantiles}
\alias{as.expression.GEVAQuantiles}
\alias{as.SVTable.GEVAQuantiles}
\title{GEVA Quantiles Grouping Results}

\value{
A \code{\linkS4class{GEVAQuantiles}} object
}
\description{
The \code{GEVAQuantiles} class represents the results of a quantile detection analysis. For each probe/gene, there is a assigned quantile among the \emph{g} defined quantiles.

This class inherits from \code{\linkS4class{GEVAGroupSet}} and is inherited by \code{\linkS4class{GEVAQuantilesAdjusted}}.
}
\section{Slots}{

\describe{
\item{\code{grouping}}{\code{factor} (\emph{m} elements, \emph{g} levels), quantile assignment for each gene/probe
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{scores}}{\code{numeric} vector (\emph{m} elements) with the assigned quantile scores for each gene/probe
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{ftable}}{\code{data.frame} (\emph{m} lines) with additional quantile assignment features
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{centroids}}{\code{numeric SVTable} (\emph{g} lines) with the S and V centroid coordinates for each quantile
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{offsets}}{\code{numeric SVTable} (\emph{m} lines) with the S and V coordinate offsets each gene/probe from its quantile centroid
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{info}}{\code{list} of additional information
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{svscores}}{\code{numeric \linkS4class{SVTable}} (\emph{m} lines) with individual partial scores for the assigned quantiles}

\item{\code{qareasizes}}{\code{numeric \linkS4class{SVTable}} (\emph{g} lines) with the S and V sizes for each quantile}

\item{\code{qindexes}}{\code{integer \linkS4class{SVTable}} (\emph{g} lines) representing the position index to each quantile, in terms of summary and variation}

\item{\code{qcount}}{integer attributes (\code{\linkS4class{SVIntAttribute}}) with the defined number of quantiles for the S and V axes}

\item{\code{qcutoff}}{numeric attributes (\code{\linkS4class{SVNumAttribute}}) with the initial quantile cutoff in S and V, starting from the point zero}

\item{\code{qmethod}}{\code{character}, method used to calculate the initial quantiles (see \code{\link[=geva.quantiles]{geva.quantiles()}})}
}}

\section{Methods}{
(See also the inherited methods from \code{\linkS4class{GEVAGroupSet}})\cr 

\sspace\cr\strong{Conversion and coercion}
\describe{
\item{\code{as.expression(x, sv, ...)}}{Converts this object to \code{expression}}
\item{\code{as.SVTable(
  x,
  which = c("sv", "offsets", "centroids", "qindexes"),
  ...,
  row.names = names(x)
)}}{Converts this object to \code{SVTable}}
}
\sspace\cr\strong{Plotting}
\describe{
\item{\code{lines(x, ...)}}{Draws the quantile delimiter lines}
\item{\code{plot(x, y, ...)}}{Draws a SV-plot that highlights the points from each quantile. Dashed lines are included as the quantile delimiters.
\cr Can be combined with another \code{SVTable} or \code{GEVAGroupSet} given as the \code{y} argument to include additional graphical elements}
}
\sspace\cr\strong{Properties}
\describe{
\item{\code{cluster.method(object)}}{Returns the option used as the \code{cluster.method} argument when calling \code{geva.cluster}.
\cr Instances of this object always return \code{'quantiles'}}
}
\sspace\cr\strong{Sub-slot accessors}
\describe{
\item{\code{classification.table(object) <- value}}{Sets the \code{data.frame} with the qualitative contrasts of classification relevance}
\item{\code{classification.table(object)}}{Gets a \code{data.frame} with the qualitative contrasts of classification relevance}
\item{\code{quantiles(object)}}{Gets the unique quantile names}
}
}

