% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_GEVAInput.R
\docType{class}
\name{GEVAInput-class}
\alias{GEVAInput-class}
\alias{show,GEVAInput-method}
\alias{[,GEVAInput,ANY,ANY,ANY-method}
\alias{plot,GEVAInput,missing-method}
\alias{inputdata,GEVAInput-method}
\alias{inputvalues,GEVAInput-method}
\alias{inputweights,GEVAInput,missing-method}
\alias{inputweights,GEVAInput,logical-method}
\alias{featureTable,GEVAInput-method}
\alias{featureTable<-,GEVAInput,data.frame-method}
\alias{infolist,GEVAInput,missing-method}
\alias{infolist,GEVAInput,character-method}
\alias{infolist<-,GEVAInput,list-method}
\alias{factors,GEVAInput-method}
\alias{factors<-,GEVAInput,factor-method}
\alias{factors<-,GEVAInput,character-method}
\alias{dim,GEVAInput-method}
\alias{dimnames,GEVAInput-method}
\alias{dimnames<-,GEVAInput,list-method}
\alias{length,GEVAInput-method}
\alias{inputnames,GEVAInput-method}
\alias{names,GEVAInput-method}
\alias{analysis.params,GEVAInput-method}
\alias{levels.GEVAInput}
\alias{head.GEVAInput}
\alias{tail.GEVAInput}
\alias{as.array.GEVAInput}
\title{GEVA Input Data}

\value{
A \code{\linkS4class{GEVAInput}} object
}
\description{
The \code{GEVAInput} class contains the initial data for \code{GEVA} usage.
It stores numeric matrices of \emph{logFC} values from differential expression comparison results. Options for calculations and summarizing are also included.
}
\section{Slots}{

\describe{
\item{\code{values}}{\verb{numeric matrix} (\emph{m*n}) of log-ratio values, usually \emph{logFC}}

\item{\code{weights}}{\verb{numeric matrix} (\emph{m*n}) of weighted values. If not defined, all weight values are equal to 1}

\item{\code{factors}}{\code{factor} (\emph{n} elements) representing the grouping of the n columns. If not defined, all factors are equal to \code{NA}}

\item{\code{ftable}}{\code{data.frame} with \emph{m} rows containing attribute columns associated to the features (\emph{e.g.}, probes or genes)}

\item{\code{info}}{\code{list} of supplementary information related to the input}
}}

\section{Methods}{

\sspace\cr\strong{Alternative accessors}
\describe{
\item{\code{levels(x)}}{Returns the unique values from the assigned factors; or \code{NA} if there are no assigned factors in \code{x}}
}
\sspace\cr\strong{Conversion and coercion}
\describe{
\item{\code{as.array(x, ...)}}{Converts this object to \code{array}}
}
\sspace\cr\strong{Dimension accessors}
\describe{
\item{\code{dim(x)}}{Gets the dimensions defined for both matrices in \code{values} and \code{weights} slots}
\item{\code{dimnames(x) <- value}}{Sets the \code{list} with the row and column names. \cr Individual dimension names can also be set using \code{rownames<-} and \code{colnames<-}}
\item{\code{dimnames(x)}}{Gets a \code{list} with the row and column names. \cr Individual dimension names can also be accessed through \code{rownames} and \code{colnames}}
\item{\code{inputnames(object)}}{Gets the input column names (same as \code{colnames(object)})}
\item{\code{length(x)}}{Returns the number of rows in the \code{values} slot}
\item{\code{names(x)}}{Same as \code{inputnames}. For internal use}
}
\sspace\cr\strong{Plotting}
\describe{
\item{\code{plot(x, y, ...)}}{Summarizes the input using the default parameters, then calls the plot on the returned \code{GEVASummary} object.
\cr Not intended to regular use and will give a warning if called}
}
\sspace\cr\strong{Properties}
\describe{
\item{\code{analysis.params(gobject)}}{Returns a \code{list} of analysis parameters passed to \code{\link{geva.merge.input}} or \code{\link{geva.read.tables}} to obtain this object}
}
\sspace\cr\strong{Subsetting}
\describe{
\item{\code{head(x, n = 6L, ...)}}{Returns the first parts of the \code{values} table}
\item{\code{tail(x, n = 6L, ...)}}{Returns the last parts of the \code{values} table}
}
}

