#' @keywords internal
"_PACKAGE"

#' @title GEVA: Gene Expression Variation Analysis
#'
#' @description Statistic methods to evaluate variation between multiple biological conditions.
#'
#'
#' @docType package
#' @name geva
#' @rdname geva-package
#' 
#' @importFrom grDevices adjustcolor chull hsv
#' @importFrom graphics abline lines plot.default points points.default polygon
#' @importFrom methods callNextMethod extends findMethodSignatures formalArgs getAllSuperClasses getClassDef getMethod getSlots hasMethod is new show slot slotNames validObject
#' @importFrom utils head tail .S3methods isS3method read.delim
#' @importFrom stats cutree lm.fit lm.wfit median model.matrix na.exclude na.omit rnorm runif setNames
#' 
#' 
#' @importFrom matrixStats rowAnys weightedMean weightedMedian weightedSd weightedVar weightedMad
#' @importFrom fastcluster hclust.vector
NULL

.onLoad <- function(libname, pkgname){
  if(isNamespaceLoaded('roxygen2'))
  {
    Sys.setenv(`_R_S3_METHOD_REGISTRATION_NOTE_OVERWRITES_`=FALSE)
  }
}