% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{loadCollection}
\alias{loadCollection}
\title{Loads a collection of pathways from the repository}
\usage{
loadCollection(rp, collection)
}
\arguments{
\item{rp}{A repository created by \code{\link{createRepository}}.}

\item{collection}{One of the names returned by
\code{getCollections}.}
}
\value{
a \code{GeneSetCollection} object loaded from the
    repository \code{rp}.
}
\description{
Loads a collection of pathways from the repository
}
\examples{

db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
geps <- loadSampleGEP()

loadCollection(rp, "c3_TFT")

unlink(repo_path, TRUE)

}
