% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{importMSigDB.xml}
\alias{importMSigDB.xml}
\title{Imports pathways data from an MSigDB XML file.}
\usage{
importMSigDB.xml(fname, organism = "Homo Sapiens")
}
\arguments{
\item{fname}{Path to an XML file downloaded from MSigDB.}

\item{organism}{Select only gene sets for a given organism. Default
is "Homo Sapiens".}
}
\value{
A CategorizedCollection object
}
\description{
Creates a \code{GeneSetCollection} object using the XML
distribution of the MSigDB (see references). The returned object
can be passed to \code{createRepository}.
}
\details{
This function now just calls \code{getBroadSets(fname)}
    from the \code{GSEABase} package. However, it is left for
    backward compatibility and as an entry point to package
    functionalities.
}
\examples{
\dontrun{

## To run this example, first obtain the MSigDB database in XML
## format (see
## http://software.broadinstitute.org/gsea/downloads.jsp). It is
## assumed that the database is locally available as the file
## "msigdb_v6.0.xml".

db <- importMSigDB.xml("msigdb_v6.0.xml")

## The database is now in an acceptable format to create a local
## repository using createRepository
}

## A small excerpt from the MSigDB is included in gep2pep. The
## following creates (and then deletes) a gep2pep repository.

db_sample <- loadSamplePWS()

repo_path <- file.path(tempdir(), "gep2pepTemp")
rp <- createRepository(repo_path, db_sample)

## removing temporary repository
unlink(repo_path, TRUE)
}
\references{
\url{http://software.broadinstitute.org/gsea/downloads.jsp}
}
