% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{createMergedRepository}
\alias{createMergedRepository}
\title{Merge multiple PEPs to build a repository of consensus PEPs}
\usage{
createMergedRepository(rpIn_path, rpOut_path, mergestr,
  progressBar = TRUE, collections = "all")
}
\arguments{
\item{rpIn_path}{path to existing gep2pep repository}

\item{rpOut_path}{path where the new merged repository will be
created}

\item{mergestr}{a named list of character vectors, each one
including a set of PEP names. For each list entry, a consensus PEP
will be created and assigned the entry name.}

\item{progressBar}{if TRUE, show a progress bar}

\item{collections}{A subset of the collection names returned by
\code{getCollections}. If set to "all" (default), all the
collections in \code{rp} will be used.}
}
\value{
Nothing, used for side effects.
}
\description{
Merge multiple PEPs to build a repository of consensus PEPs
}
\details{
The merging is performed as follows. Given N PEPs, the
corresponding consensus PEP will get as enrichement score the
average enrichment scores of the N PEPs, and as p-value the
composition of the N PEP p-values by Fisher's method.
}
\examples{

db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")
rp <- createRepository(repo_path, db)
geps <- loadSampleGEP()
buildPEPs(rp, geps)

mergestr <- list(
    che_iso = c("(+)_chelidonine", "(+)_isoprenaline"),
    cat_mk = c("(+/_)_catechin", "(_)_mk_801")
)

merged_path <- file.path(tempdir(), "gep2pepTempMerged")

createMergedRepository(repo_path, merged_path, mergestr)

unlink(repo_path, TRUE)
unlink(merged_path, TRUE)
}
