% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.r
\name{plot.inferCNV}
\alias{plot.inferCNV}
\title{Plot chromosome map}
\usage{
\method{plot}{inferCNV}(x, output = NULL, threshold = 0.2, gamma = 1.5, resolution = 150, ...)
}
\arguments{
\item{x}{Object of class inferCNV}

\item{output}{Optional output PDF file name (with extension)}

\item{threshold}{Likelihood threshold for identifying genomically inestable
cells/samples, 0 disables this filter}

\item{gamma}{Number indicating the gamma transformation for the colors}

\item{resolution}{Integer indicating the ppi for the png and jpg output files}

\item{...}{Additional parameters for plot}
}
\value{
Nothing, a plot is generated in the default output devise
}
\description{
This function generates a chromosomes map plot for the inferred CNVs
}
\examples{

eh <- ExperimentHub::ExperimentHub()
dset <- eh[["EH5419"]]
tpm_matrix <- SummarizedExperiment::assays(dset)$TPM
set.seed(1)
tpm_matrix <- tpm_matrix[, sample(ncol(tpm_matrix), 500)]
cnv <- inferCNV(tpm_matrix)
cnv <- genomicInstabilityScore(cnv)
cnv <- giLikelihood(cnv, distros=c(3, 3), tumor=2:3)
\donttest{plot(cnv, output='test.png')}

}
\seealso{
[giLikelihood()] to estimate the relative likelihood,
[genomicInstabilityScore()] to estimate the genomic instability score for
each cell in the dataset, and [inferCNV()] to infer the enrichment
of loci-blocks in the gene expression data.
}
