% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.r
\name{inferCNV}
\alias{inferCNV}
\title{Inference of CNV from expression data}
\usage{
inferCNV(
  expmat,
  nullmat = NULL,
  species = c("human", "mouse"),
  k = 100,
  skip = 25,
  min_geneset = 10,
  verbose = TRUE
)
}
\arguments{
\item{expmat}{Matrix of gene expression profiles or signatures with genes
'(entrezID) in rows and samples in columns}

\item{nullmat}{Optional matrix with same number of rows as \code{expmat} to
be used as null model}

\item{species}{Character string indicating the species, either human or mouse}

\item{k}{Integer indicating the number of genes per set}

\item{skip}{Interger indicating the displacement of the window for selecting
the k genes}

\item{min_geneset}{Integer indicating the minimum size for the genesets}

\item{verbose}{Logical, whether progress should be reported}
}
\value{
Object of class inferCNV, which is a list containing matrix of nes,
and parameters (param), including species, window (k) and skip
}
\description{
This function estimates the CNV score based on expression data
}
\examples{
eh <- ExperimentHub::ExperimentHub()
dset <- eh[["EH5419"]]
tpm_matrix <- SummarizedExperiment::assays(dset)$TPM
set.seed(1)
tpm_matrix <- tpm_matrix[, sample(ncol(tpm_matrix), 500)]
cnv <- inferCNV(tpm_matrix)
class(cnv)
names(cnv)
cnv$nes[1:5, 1:3]

}
