% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGff3.R
\name{readGff3,character-method}
\alias{readGff3,character-method}
\alias{readGff3}
\alias{readZeroLengthFeaturesGff3}
\alias{readZeroLengthFeaturesGff3,character-method}
\alias{readBasePairFeaturesGff3}
\alias{readBasePairFeaturesGff3,character-method}
\alias{writeGff3}
\alias{writeGff3,data.frame-method}
\alias{writeGff3,Genome_intervals-method}
\alias{.readGff3}
\title{readGff3}
\usage{
readGff3(file, isRightOpen=FALSE, quiet=FALSE)
readBasePairFeaturesGff3(file, quiet=FALSE)
readZeroLengthFeaturesGff3(file, quiet=FALSE)
writeGff3(object, file)
}
\arguments{
\item{file}{The name of the gff file to read/write.}

\item{isRightOpen}{Although it is arguable that a GFF3 file might have a right-open intervals convention - the format
description being at best imprecise - most GFF3 file follow a right-closed convention. Hence, as of version 1.25.1,
the default has been changed to \code{isRightOpen = FALSE}. See the details section on how to restore the older
behaviour.}

\item{quiet}{a boolean to turn verbosity off when reading a Gff3 file}

\item{object}{a \code{\link[=Genome_intervals-class]{Genome_intervals}} object}
}
\value{
\itemize{
  \item{readGff3 and friends}{A \code{\link[=Genome_intervals_stranded-class]{Genome_intervals_stranded}} object image of the
gff file. The GFF3 fields \code{seqid}, \code{source}, \code{type}, \code{score}, \code{strand}, \code{phase} and
\code{attributes} are stored in the \code{annotation} slot and renamed as \code{seq_name}, \code{source},
\code{type}, \code{score}, \code{strand}, \code{phase} and \code{gffAttributes} respectively.}
  \item{writeGff3}{It dispatches to \code{write.table} and hence returns similar values.}
}
}
\description{
Read (write) a Genome_intervals_stranded object from (to) a GFF3 file
}
\details{
\itemize{
  \item{readGff3}{
    Make a \code{\link[=Genome_intervals_stranded-class]{Genome_intervals_stranded}} object from a gff file in gff3 format.}
  \item{readBasePairFeaturesGff3}{
    Same as \code{readGff3} assuming \code{isRightOpen='FALSE'}, i.e. no zero length intervals are created. This
    is the default behaviour since v1.25.1.
  }
  \item{readZeroLengthFeaturesGff3}{
    Same as \code{readGff3} assuming \code{isRightOpen='TRUE'}, i.e. zero length intervals are created when
    a feature's start is the same as its end. This was the default prior to version 1.25.1.
  }
  \item{writeGff3}{
    Write a \code{\link[=Genome_intervals-class]{Genome_intervals}} object to a gff file in gff3 format.
  }}

The file must follow gff3 format specifications as in
\url{http://www.sequenceontology.org/gff3.shtml}. Due to the imprecise definition and to
allow for zero-length features, the default for reading a Gff3 file has been to assume
right open intervals (until v1.25.1). As by then, the community consensus has been to use
closed intervals, the default behaviour of readGff3 has been changed accordingly. The
\code{readGff3 file} is now a wrapper that dispatches to two sub functions - which may be used
directly - \code{readBasePairFeaturesGff3} and \code{readZeroLengthFeaturesGff3}. The former
assumes closed intervals and hence does not create zero-length intervals. The latter does the
opposite and uses right-open intervals!

Some more noteworthy details:

The file is read as a table and meta-information (lines starting with ###) are not parsed.

A \dQuote{.} in, for example, the gff file's \emph{score} or \emph{frame}
field will be converted to \code{NA}.

When the GFF file follows the right-open interval convention (\code{isRightOpen} is \code{TRUE}), then
GFF entries for which end base equals first base are recognized as zero-length features
and loaded as \code{inter_base} intervals.

Strand entries in the file are expected to be '.', '?', '+' or '-'. The two first are mapped to \code{NA}.

It can be that readGff3 is able to construct a \code{\link[=Genome_intervals_stranded-class]{Genome_intervals_stranded}} object from the input file, although not valid.
A warning message is then generated and the constructed object is returned to allow inspection of it.

Potential FASTA entries at the end of the file are ignored.
}
\examples{
# Get file path
libPath <- installed.packages()["genomeIntervals", "LibPath"]
filePath <- file.path(
 libPath,
 "genomeIntervals",
 "example_files"
)

# Load SGD gff
# SGD does not comply to the GFF3 right-open interval convention
gff <- readGff3( file.path( filePath, "sgd_simple.gff"), isRightOpen = FALSE)

head(gff,10)

head(annotation(gff),10)

\dontrun{
## write the gff3 file
writeGff3(gff,file="sgd_simple.gff")
}

}
\seealso{
The functions \code{\link{getGffAttribute}} and \code{\link{parseGffAttributes}} for parsing GFF attributes.
}
