% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\docType{methods}
\name{readNarrowPeak}
\alias{readNarrowPeak}
\title{A function to read the Encode formatted narrowPeak file into a GRanges object}
\usage{
readNarrowPeak(file, track.line=FALSE, zero.based=TRUE)
}
\arguments{
\item{file}{an absolute or relative path to a bed file formatted by the Encode 
narrowPeak standard. The file can end in \code{.gz}, \code{.bz2}, 
\code{.xz}, or \code{.zip} and/or start with \code{http://} or 
\code{ftp://}. If the file is not compressed
it can also start with \code{https://} or \code{ftps://}.}

\item{track.line}{the number of track lines to skip, "auto" to detect them automatically
or FALSE(default) if the bed file doesn't have track lines}

\item{zero.based}{a boolean which tells whether the ranges in 
the bed file are 0 or 1 base encoded. (Default: TRUE)}
}
\value{
a GRanges object
}
\description{
A function to read the Encode formatted narrowPeak file into a GRanges object
}
\examples{
narrow.peak.file = system.file('extdata',"ex.narrowPeak", package='genomation')
                 
narrow.peak = readBroadPeak(narrow.peak.file)
head(narrow.peak)
}
