% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\docType{methods}
\name{gffToGRanges}
\alias{gffToGRanges}
\title{Converts a gff formated data.frame into a GenomicRanges object. 
The GenomicRanges object needs to be properly formated for the function to work.}
\usage{
gffToGRanges(gff.file, filter = NULL, zero.based = FALSE, ensembl = FALSE)
}
\arguments{
\item{gff.file}{path to a gff formatted file. 
The file can end in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip}
and/or start with \code{http://} or \code{ftp://}. If the file is not compressed
it can also start with \code{https://} or \code{ftps://}.}

\item{filter}{a character designating which elements to retain from the gff file (e.g. exon, CDS, ...)}

\item{zero.based}{\code{boolean} whether the coordinates are 0 or 1 based. 0 is the default}

\item{ensembl}{\code{boolean} if TRUE, add the chr prefix to seqlevels. FALSE by default}
}
\value{
returns a \code{GenomicRanges} object
}
\description{
Converts a gff formated data.frame into a GenomicRanges object. 
The GenomicRanges object needs to be properly formated for the function to work.
}
\examples{
gff.file = system.file('extdata/chr21.refseq.hg19.gtf', package='genomation')
gff = gffToGRanges(gff.file)

}
