% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRandomEnrichment.R
\docType{methods}
\name{getRandomEnrichment}
\alias{getRandomEnrichment}
\alias{getRandomEnrichment,GRanges,GRanges-method}
\title{get enrichment based on randomized feature overlap}
\usage{
getRandomEnrichment(target, query, randomizations = 1000, rand.set = NULL,
  ...)

\S4method{getRandomEnrichment}{GRanges,GRanges}(target, query,
  randomizations = 1000, rand.set = NULL, ...)
}
\arguments{
\item{target}{a \code{GRanges} object to be overlapped with \code{query}}

\item{query}{a \code{GRanges} object that will be randomly placed across the genome and overlap of these random regions with \code{target} will be the background distribution of association between \code{target} and \code{query}.}

\item{randomizations}{number of times the features to be shuffled}

\item{rand.set}{instead of randomly placing features in \code{query} one can supply an already shuffled set of \code{query} genomic features.}

\item{...}{other parameters to be passed to \code{randomizeFeature} function. These parameters ccontrol how randomization is done.}
}
\value{
returns a \code{RandomEnrichment} object
}
\description{
This function measures the association between two genomic features by randomizing one feature and counting the overlaps in randomized sets.
That is to say, \code{query} feature will be randomly distributed over the genome (constrained by provided options), and the overlap of \code{target} with these randomized features will be measured.
}
\examples{
data(cage)
data(cpgi)
\donttest{ 
enr = getRandomEnrichment(cage, cpgi, randomizations=50)
}
}
\seealso{
\code{\link{randomizeFeature}}
}
