% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vdxs}
\alias{vdxs}
\alias{data.vdxs}
\alias{annot.vdxs}
\alias{demo.vdxs}
\title{Gene expression, annotations and clinical data from Wang et al. 2005 and Minn et al 2007}
\format{
\code{vdxs} is a dataset containing three matrices:
\itemize{
\item data.vdxs: Matrix containing gene expressions as measured by Affymetrix hgu133a technology (single-channel, oligonucleotides)
\item annot.vdxs: Matrix containing annotations of ffymetrix hgu133a microarray platform
\item demo.vdxs: Clinical information of the breast cancer patients whose tumors were hybridized
}
}
\source{
\url{http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE2034}

\url{http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE5327}
}
\description{
This dataset contains (part of) the gene expression, annotations and clinical data as published in Wang et al. 2005 and Minn et al 2007.
}
\details{
This dataset represent only partially the one published by Wang et al. 2005 and Minn et al 2007. Indeed only part of the patients (150) and gene expressions (966) are contained in \code{data.vdxs}.
}
\references{
Y. Wang and J. G. Klijn and Y. Zhang and A. M. Sieuwerts and M. P. Look and F. Yang and D. Talantov and M. Timmermans and M. E. Meijer-van Gelder and J. Yu and T. Jatkoe and E. M. Berns and D. Atkins and J. A. Foekens (2005) "Gene-Expression Profiles to Predict Distant Metastasis of Lymph-Node-Negative Primary Breast Cancer", \emph{Lancet}, \emph{365}:671--679

Minn, Andy J. and Gupta, Gaorav P. and Padua, David and Bos, Paula and Nguyen, Don X. and Nuyten, Dimitry and Kreike, Bas and Zhang, Yi and Wang, Yixin and Ishwaran, Hemant and Foekens, John A. and van de Vijver, Marc and Massague, Joan (2007) "Lung metastasis genes couple breast tumor size and metastatic spread", \emph{Proceedings of the National Academy of Sciences}, \emph{104}(16):6740--6745
}
\keyword{data}
